definition module controllayout

import ioTypes

:: NewItemPos :== ( ItemLoc, ItemOffset )

:: ItemLoc
	=  NLeftTop
	|  NRightTop
	|  NLeftBottom
	|  NRightBottom
	|  NLeft
	|  NCenter
	|  NRight
	|  NLeftOf  Id
	|  NRightTo Id
	|  NAbove   Id
	|  NBelow   Id

:: ItemOffset :== (Int, Int)

calcItemPositions :: !(!Int,!Int) !(!Int,!Int) !Size !Size ![ItPos] -> (!Size,![ItPos])

::	ItPos
	=	{	ipId		:: Id					
	    ,   ipCtrlId    :: Id                   // The ControlId
		,	ipPos		:: NewItemPos			// The given NewItemPos
		,	ipRect		:: Rect					// Position (x,y) and size (w,h) of item (x,y,w,h)
		,	ipDepends	:: [RCPos]				// Dependent items (this item is Renter/Corner item)
		,	ipOffset	:: ItemOffset			// The vector by which compound elements should be moved
		}

newItPos :: !Int !Id !NewItemPos !Size -> ItPos

::	RCPos
	=	{	cpId		:: Id					
        ,   cpCtrlId    :: Id					// The ControlId
		,	cpRect		:: Rect					// Position (x,y) and size (w,h) of item (x,y,w,h)
		,	cpOffset	:: ItemOffset			// The vector by which compound elements should be moved
		}
